<?Lassoscript
Define_Type: 'C_DBSpec', -prototype;
	local: 'database' = '';
	local: 'username' = '';
	local: 'password' = '';
	
	Define_Tag: 'onCreate', -required='database', -required='username', -required='password';
		self->'database' = #database;
		self->'username' = #username;
		self->'password' = #password;
	/Define_Tag;
	
	Define_Tag: 'getSpec';
		return: self->toArray;
	/Define_Tag;
	
	Define_Tag: 'onConvert';
		select: params->(get: 1);
			case: 'string';
				return: self->toString;
			case: 'array';
				return: self->toArray;
		/select;
		return: null;
	/Define_Tag;
	
	Define_Tag: 'toString';
		return: self->toArray;
	/Define_Tag;

	Define_Tag: 'toArray';
		return: (array: -database=self->'database', -username=self->'username', -password=self->'password');
	/Define_Tag;
/Define_Type;


Define_Type: 'C_Record', -prototype;
	local: 'key' = null;
	local: 'table' = '';
	local: 'keyField' = '';

	Define_Tag: 'getKey';		//getting the the key instance variable
		return: self->key;
	/Define_Tag;
	
	/* You will rarely use the setKey method outside the custom type hierarchy */
	Define_Tag: 'setKey', -required='key';	//setting the key instance variable
		self->'key' = (self->(isValidKey: #key) ? #key | null);
	/Define_Tag;
	
	Define_Tag: 'hasValidKey';
		return:  self->(isValidKey: self->'key');
	/Define_Tag;
	
	Define_Tag: 'isValidKey', -required='key';
		return: #key != null && (integer: #key) != 0;
	/Define_Tag;
	
	Define_Tag: 'load', -required='key';
		if: self->(isValidKey: #key);
			inline: -search, $gDBspec->getSpec, -table=self->'table', -keyfield=self->'keyfield', -maxrecords=1, -keyvalue=#key;
				records;
					self->(setKey: -key=(field: self->'keyfield'));
					self->LoadX;
				/records;
			/inline;
		/if;
	/Define_Tag;
	
	Define_Tag: 'loadX';
	/Define_Tag;
	
	Define_Tag: 'save';
		if: self->hasValidKey;	//this is an update operation
			inline: -update, $gDBspec->getSpec, -table=self->'table', -keyfield=self->'keyfield', -keyvalue=self->GetKey, params;
			/inline;			
		else;	//this is an add operation
			inline: -add, $gDBspec->getSpec, -table=self->'table', -keyfield=self->'keyfield', -keyvalue=self->GetKey, params;
				self->(setKey: -key=keyfield_value);		//it is important to set the key of the object, so the live object is considered valid
			/inline;
		/if;
	/Define_Tag;

	Define_Tag: 'delete';
		if: self->hasValidKey;	//this is an add operation
			inline: -delete, $gDBspec->getSpec, -table=self->'table', -keyfield=self->'keyfield', -keyvalue=self->GetKey;
				self->(setKey: -key=null);		//it is important to set the key of the object so that it is considered invalid
			/inline;
		/if;
	/Define_Tag;
	
	Define_Tag: 'getList';
		local: 'result' = array;
		
		local: 'oneRecord' = map;
		inline: -search, $gDBspec->getSpec, -table=self->'table', -keyfield=self->'keyfield', -maxrecords='all';
			records;
				#oneRecord = (\(self->type))->Invoke;
				#oneRecord->(setKey: -key=(field: self->'keyfield'));
				#oneRecord->loadX;
				#result->(insert: #oneRecord);
			/records;
		/inline;
		return: #result;		
	/Define_Tag;
/Define_Type;


Define_Type: 'C_Contact', 'C_Record', -prototype;
	local: 'table' = 'contact';
	local: 'keyField' = 'key';

	local: 'firstname' = '';
	local: 'lastname' = '';
	
	Define_Tag: 'loadX';
		self->'firstname' = (field: 'firstname');
		self->'lastname' = (field: 'lastname');
	/Define_Tag;
	
	Define_Tag: 'save';
		self->parent->(save:
			'firstname'=self->'firstname',
			'lastname'=self->'lastname'
		);
	/Define_Tag;
	
	Define_Tag: 'setName', -required='firstname', -required='lastname';
		self->'firstname' = #firstname;
		self->'lastname' = #lastname;
	/Define_Tag;
	
	Define_Tag: 'getName';
		return: self->'firstname' + ' ' + self->'lastname';
	/Define_Tag;
/Define_Type;

?>